################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
BEGIN {
    printf "<grid:host-list type=\"pbs\" cluster=\"" escapeXmlAttribute(PBS_CLUSTER_ID) "\" xmlns:grid=\"http://www.enginframe.com/2000/GRID\">\n"
}

END {
    writeTag()
    printf "</grid:host-list>\n"
}

/^[^ ]+$/ {
    writeTag()
}

{
    readValue()
}

function readValue() {
    if ($0 ~ /^[^ ]+$/) {
        field["name"] = $0
    } else if ($0 ~ /^ +[^ ]+ = /) {
        param = ""
        value = ""

        eq_pos = index($0, "=")
        if (eq_pos > 0) {
            param_part = substr($0, 1, eq_pos - 1)
            value = substr($0, eq_pos + 2)  # skip '=' and space
            gsub(/^ +| +$/, "", param_part)  # trim leading/trailing spaces
            param = param_part
        }
        if (param == "state") {
            # <various> means that there are many vnodes with different states. For now we assume
            # that at least one of them is ok and so the node can still run jobs
            field["grid"] = value
            if (value == "" || value == "free" || value == "<various>") {
                field["ef"] = "ok"
            } else if (value ~ /(.*busy|job-exclusive)$/) {
                field["ef"] = "busy"
            } else if (value ~ /(.*exclusive|stale|.*provisioning|state-unknown|down|unresolvable)$/) {
                field["ef"] = "unavailable"
            } else if (value == "offline") {
                field["ef"] = "closed"
            } else {
                field["ef"] = "unknown"
            }
        }
        if (match(value, /^[0-9]+[^0-9]+/)) {
            number = substr(value, RSTART, RLENGTH)
            sub(/[^0-9]+$/, "", number)

            unit = value
            sub(/^[0-9]+/, "", unit)
            unit = tolower(unit)
            if      (unit == "kb") { normalizedValue = number * 1024; value = number"K" }
            else if (unit == "mb") { normalizedValue = number * 1048576; value = number"M" }
            else if (unit == "gb") { normalizedValue = number * 1073741824; value = number"G" }
            else if (unit == "tb") { normalizedValue = number * 1099511627776; value = number"T" }
            else { normalizedValue = value }
            field["normalized_"param] = normalizedValue
        }
        field[param] = value
    }
}

function writeTag() {
    if (field["name"] != "") {
        if (field["resources_available.arch"] == "") field["resources_available.arch"]="unknown"
        printf "  <grid:host type=\"pbs\" name=\"%s\" arch=\"%s\" arch-family=\"%s\" ncpus=\"%s\">\n",
            escapeXmlAttribute(field["name"]),
            field["resources_available.arch"],
            toupper(field["resources_available.arch"]),
            escapeXmlAttribute(field[pcpus])
        printf "    <grid:status base=\"\" batch=\"%s\" ef=\"%s\" grid=\"%s\" />\n",
            escapeXmlAttribute(field["grid"]),
            field["ef"],
            escapeXmlAttribute(field["grid"])
        if (field["max_running"] > 0) printf "    <grid:job-slots>%s</grid:job-slots>\n", field["max_running"]
        else printf "    <grid:job-slots>%s</grid:job-slots>\n", field["resources_available.ncpus"]
        printf "    <grid:usage running-jobs=\"%s\" />\n",
            split(field["jobs"], jobs, ", ")
        if (field["normalized_resources_available.mem"]) printf "    <grid:resource name=\"mem\" max=\"%s\">%s</grid:resource>\n",
            field["normalized_resources_available.mem"],
            field["normalized_resources_available.mem"] - field["normalized_resources_assigned.mem"]
        if (field["resources_available.ncpus"] && field["resources_available.ncpus"] > 0) printf "    <grid:resource name=\"ut\" max=\"100\">%s</grid:resource>\n",
            field["resources_assigned.ncpus"] / field["resources_available.ncpus"] * 100
        for (param in field) {
            if (param ~ /^resources_/) {
                printf "    <grid:resource name=\"%s\">%s</grid:resource>\n",
                    param, escapeXmlContent(field[param])
            }
        }
        printf "  </grid:host>\n"
    }
    delete field
}
