################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################

BEGIN {
    print "<grid:job-list type=\"pbs\" cluster=\"" escapeXmlAttribute(PBS_CLUSTER_ID) "\" xmlns:grid=\"http://www.enginframe.com/2000/GRID\">" ;
    FS=" "; oldJobId = ""; statesCount = 0; totalJobs = 0;

    # Read status mapping file
    while (getline < statusmap > 0) {
      split($0,statusLabel,":");
      s=split(statusLabel[2],gridStates," ");
      statesCount++;
      efStatesMap[statesCount]=statusLabel[1];
      efStatusCounter[statusLabel[1]]=0;
      for (i=1;i<=s;i++) {
        efStates[gridStates[i]]=statusLabel[1]
      }
    } 
    close(statusmap);

}

END {
    printXML();
    print "</grid:job-list>";
}

/^Job Id:/                 { sub(/\[.*$/, "", $3);
                             JOBID=$3;
                             if (JOBID == oldJobId)
                                 printInfo = 0
                             else {
                                 clearVars()
                                 oldJobId = JOBID
                             }
                           }

/^Job_Name =/              { if (printInfo) { JOBNAME=$3; _EF_JOB_NAME = $1 }}

/^Job_Owner =/             { if (printInfo) { 
                                  split($3,userdata,"@");
                                  OWNER=userdata[1]
                                  SUBMISSION_HOST=userdata[2] }}

/^queue =/                 { if (printInfo) { QUEUE=$3 }}

/^resources_used.cput =/   { CPU_USAGE=CPU_USAGE " " $3 }

/^resources_used.mem =/    { sub(/kb/,"", $3);
                             MEMORY_USAGE=MEMORY_USAGE + $3 }

/^resources_used.vmem =/   { sub(/kb/,"", $3);
                             SWAP_USAGE=SWAP_USAGE + $3 }

/^job_state =/             { 
                             # --- EF 2013 Job status mapping ---
                             efStatus = efStates[$3];
                             if (efStatus=="") efStatus="Unknown"
                             efStatusCounter[efStatus]++
                             totalJobs++

                             # --- PBS job status ---
                             gridStatus=$3
                           }

/^exec_host =/             { if (printInfo) {
                               split($3, h, "+")
                               for (i in h) {
                                   gsub(/\/.*$/, "", h[i])
                                   if (EXECUTION_HOST == "")
                                       EXECUTION_HOST=h[i]
                                   else
                                       EXECUTION_HOST=EXECUTION_HOST + " " + h[i]
                               }
                             }
                           }

/^ctime =/                 { if (printInfo) {
                               split($6, event, "[ :]");
                               timestamp = "month=\"" $4 "\" day=\"" $5 "\" hour=\"" event[1] \
                                   "\" minute=\"" event[2] "\" year=\"" $7 "\""
                               SUBMISSION_TIME=timestamp
                             }
                           }

/^etime =/                 { if (printinfo) {
                               split($6, event, "[ :]");
                               timestamp = "month=\"" $4 "\" day=\"" $5 "\" hour=\"" event[1] \
                                  "\" minute=\"" event[2] "\" year=\"" $7 "\""
                               EXECUTION_TIME=timestamp
                              }
                           }

/^Exit_status =/           { if (gridStatus=="F" && $3!="" && $3!="0") {
                               efStatus="Exit"
                               efStatusCounter["Done"]--
                               efStatusCounter["Exit"]++
                             }
                           }

/^resources_used\.ncpus =/ { PARALLEL_MIN=PARALLEL_MIN + $3; PARALLEL_MAX=PARALLEL_MAX + $3 }

/^Account_Name =/          { if (printInfo) { ACCOUNT=$3 }}

/^Output_Path =/           { if (printInfo) {
                               split($3, pathdata, ":")
                               gsub(pathdata[1]":", "", $3)
                               tokens = split($3, pathdata2, "/")
                               gsub("/"pathdata2[tokens], "", $3)
                               EXECUTION_DIRECTORY=$3
                               SUBMISSION_DIRECTORY=$3
                           }}


function clearVars() {
    JOBNAME=""
    OWNER=""
    SUBMISSION_HOST=""
    QUEUE=""
    CPU_USAGE=""
    MEMORY_USAGE=""
    SWAP_USAGE=""
    EXECUTION_HOST=""
    SUBMISSION_TIME=""
    EXECUTION_TIME=""
    PARALLEL_MIN=""
    PARALLEL_MAX=""
    ACCOUNT=""
    SUBMIT_ARGS=""
    EXECUTION_DIRECTORY=""
    SUBMISSION_DIRECTORY=""
    printInfo = 1;
}


function printXML() {
    if ((GRID_TAG_SIZE_LIMIT != "") && (length(SUBMIT_ARGS) > GRID_TAG_SIZE_LIMIT)) {
        command = substr(SUBMIT_ARGS, 1, GRID_TAG_SIZE_LIMIT - 5) "[...]"
    } else {
        command = SUBMIT_ARGS
    }

    print "  <grid:job type=\"pbs\" mode=\"array\" id=\"" jobid "\" is-array=\"true\">" ;

    print "    <grid:name>" escapeXmlContent(JOBNAME) "</grid:name>"
    print "    <grid:owner>" escapeXmlContent(OWNER) "</grid:owner>"
    print "    <grid:queue>" escapeXmlContent(QUEUE) "</grid:queue>"
    if (ACCOUNT != "") print "    <grid:account>" escapeXmlContent(ACCOUNT) "</grid:account>"
    print "    <grid:command>" escapeXmlContent(command) "</grid:command>"
    print "    <grid:submission-host>" escapeXmlContent(SUBMISSION_HOST) "</grid:submission-host>"
    print "    <grid:submission-time " SUBMISSION_TIME "/>"
    print "    <grid:submission-directory>" escapeXmlContent(SUBMISSION_DIRECTORY) "</grid:submission-directory>"
    print "    <grid:parallel min=\"" PARALLEL_MIN "\" max=\"" PARALLEL_MAX "\"/>"
    if (EXECUTION_HOST != "") {
      print "    <grid:execution-host>" escapeXmlContent(EXECUTION_HOST) "</grid:execution-host>"
      print "    <grid:execution-time " EXECUTION_TIME "/>"
      print "    <grid:execution-directory>" escapeXmlContent(EXECUTION_DIRECTORY) "</grid:execution-directory>"
    }
    if (CPU_USAGE != "")  print "    <grid:total-cpu-usage>" CPU_USAGE "</grid:total-cpu-usage>"
    if (MEMORY_USAGE != "")  print "    <grid:memory-usage>" MEMORY_USAGE "</grid:memory-usage>"
    if (SWAP_USAGE != "")  print "    <grid:swap-usage>" SWAP_USAGE "</grid:swap-usage>"    

    print "    <grid:array-status>";
    print "      <grid:counter grid=\"\" ef=\"\">" totalJobs "</grid:counter>";
    for (i=1;i<=statesCount;i++) {
      status_ef=efStatesMap[i];
      status_grid=""
      status_value=efStatusCounter[status_ef];
      print "      <grid:counter grid=\"" status_grid "\" ef=\"" status_ef "\">" status_value "</grid:counter>";
    }
    print "    </grid:array-status>";

    print "  </grid:job>" ;
}

