################################################################################
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
################################################################################
################################################################################

BEGIN {
    print "<grid:job-list type=\"pbs\" cluster=\"" escapeXmlAttribute(PBS_CLUSTER_ID) "\" xmlns:grid=\"http://www.enginframe.com/2000/GRID\">" ;
    first = 1; FS=" ";

    # Read status mapping file
    while (getline < statusmap > 0) {
        split($0,fields,":");
        s = split(fields[2],label," ");
        for (i=1;i<=s;i++) {
            states[label[i]]=fields[1]
        }
    }
    close(statusmap);

}

END {
    if (!first) {
        if (gridStatus=="F" && EXIT_STATUS!="" && EXIT_STATUS!="0") {
            efStatus="Exit"
            status="EXIT"
        }
        print "    <grid:status grid=\"" gridStatus "\" ef=\"" efStatus "\">" status "</grid:status>";
        print "  </grid:job>";
    }
    print "</grid:job-list>";
}

/^Job Id:/ {
    if (!first) {
        # job array case
        if (gridStatus=="F" && EXIT_STATUS!="" && EXIT_STATUS!="0") {
            efStatus="Exit"
            status="EXIT"
        }
        print "    <grid:status grid=\"" gridStatus "\" ef=\"" efStatus "\">" status "</grid:status>";
        print "  </grid:job>";
    }
    clearVars();
    first = 0;

    if (split($3, val, "[") > 1) {
        suffix=val[2];
        sub(/].*/, "", val[2]);
        sub(/.*]/, "", suffix);
        print "  <grid:job type=\"pbs\" id=\"" $3 "\" index=\"" val[2] "\" array-id=\"" val[1] "[]" suffix "\">" ;
    } else
        print "  <grid:job type=\"pbs\" id=\"" $3 "\">" ;
}

/^Job_Name =/ {
    print "    <grid:name>" escapeXmlContent($3) "</grid:name>";
    _EF_JOB_NAME = $1
}

/^Job_Owner =/ {
    split($3,userdata,"@");
    print "    <grid:owner>" escapeXmlContent(userdata[1]) "</grid:owner>"
    print "    <grid:submission-host>" escapeXmlContent(userdata[2]) "</grid:submission-host>"
}

/^queue =/ {
    print "    <grid:queue>" escapeXmlContent($3) "</grid:queue>"
}

/^resources_used.cput =/ {
    print "    <grid:total-cpu-usage>" $3 "</grid:total-cpu-usage>"
}

/^resources_used.mem =/ {
    print "    <grid:memory-usage>" $3 "</grid:memory-usage>"
}

/^resources_used.vmem =/ {
    print "    <grid:swap-usage>" $3 "</grid:swap-usage>"
}

/^job_state =/ {
    # EF 2013 Job status mapping
    efStatus = states[$3];
    if (efStatus=="") efStatus = "Unknown"

    if (match($3, "Q")) status = "PEND"
    else if (match($3, "W")) status = "PEND"
    else if (match($3, "R")) status = "RUN"
    else if (match($3, "M")) status = "RUN"
    else if (match($3, "B")) status = "RUN"
    else if (match($3, "T")) status = "RUN"
    else if (match($3, "H")) status = "PSUSP"
    else if (match($3, "S")) status = "PSUSP"
    else if (match($3, "E")) status = "DONE"
    else if (match($3, "F")) status = "DONE"
    else if (match($3, "C")) status = "DONE"
    else if (match($3, "X")) status = "DONE"
    else status = "UNKNWN"

    # PBS job status
    gridStatus=$3
}

/^exec_host =/ {
    split($3, h, "+")
    for (i in h) {
        gsub(/\/.*$/, "", h[i])
        print "    <grid:execution-host>" escapeXmlContent(h[i]) "</grid:execution-host>"
    }
}

/^ctime =/ {
    split($6, event, "[ :]");
    timestamp = "month=\"" $4 "\" day=\"" $5 "\" hour=\"" event[1] \
        "\" minute=\"" event[2] "\" year=\"" $7 "\""
    print "    <grid:submission-time " timestamp "/>"
}

/^etime =/ {
    split($6, event, "[ :]");
    timestamp = "month=\"" $4 "\" day=\"" $5 "\" hour=\"" event[1] \
        "\" minute=\"" event[2] "\" year=\"" $7 "\""
    print "    <grid:execution-time " timestamp "/>"
}

/^Exit_status =/ {
    EXIT_STATUS=$3
}

/^resources_used\.ncpus =/ {
    print "    <grid:parallel min=\"" $3 "\" max=\"" $3 "\"/>"
}

/^Account_Name =/ {
    print "    <grid:account>" escapeXmlContent($3) "</grid:account>"
}

/^Output_Path =/ {
    colon_pos = index($3, ":")
    if (colon_pos > 0) {
        rest = substr($3, colon_pos + 1)
        slash_pos = index(rest, "/")
        if (slash_pos > 0) {
            path_prefix = substr(rest, 1, slash_pos - 1)
            print "    <grid:execution-directory>" escapeXmlContent(path_prefix) "</grid:execution-directory>"
            print "    <grid:submission-directory>" escapeXmlContent(path_prefix) "</grid:submission-directory>"
        }
    }
}

function clearVars() {
    EXIT_STATUS=""
}
