<?xml version="1.0"?>
<!--
  * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efrss="http://www.enginframe.com/2010/rss"
                xmlns:grid="http://www.enginframe.com/2000/GRID"
                xmlns:java="http://xml.apache.org/xalan/java"
                exclude-result-prefixes="ef grid java">

  <xsl:variable name="url">
    <xsl:value-of select="/efrss:metadata/efrss:variable[@name='base_url']"/>
  </xsl:variable>

  <xsl:variable name="channel_title">
    <xsl:choose>
      <xsl:when test="/efrss:metadata/efrss:variable[@name='channel_title']">
        <xsl:value-of select="/efrss:metadata/efrss:variable[@name='channel_title']"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="/efrss:metadata/ef:agent/ef:name">
          <xsl:text>EnginFrame: </xsl:text>
          <xsl:value-of select="/efrss:metadata/ef:agent/ef:name"/>
          </xsl:when>
          <xsl:otherwise>EnginFrame</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="channel_description">
    <xsl:choose>
      <xsl:when test="/efrss:metadata/efrss:variable[@name='channel_description']">
        <xsl:value-of select="/efrss:metadata/efrss:variable[@name='channel_description']"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="/efrss:metadata/ef:agent/ef:info">
            <xsl:value-of select="/efrss:metadata/ef:agent/ef:info"/>
          </xsl:when>
          <xsl:otherwise>EnginFrame</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="ttl">
    <xsl:choose>
      <xsl:when test="/efrss:metadata/efrss:variable[@name='ttl']">
        <xsl:value-of select="/efrss:metadata/efrss:variable[@name='ttl']"/>
      </xsl:when>
      <xsl:otherwise>5</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="pub-date">
    <xsl:choose>
      <xsl:when test="/efrss:metadata/efrss:variable[@name='pub-date']">
        <xsl:value-of select="/efrss:metadata/efrss:variable[@name='pub-date']"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="java:com.enginframe.common.utils.DateFormatter.currentDateTimeAsRFC822String()"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

</xsl:stylesheet>
