#!/bin/bash

#
################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################
#################################################################################


. "${EF_ROOT}/plugins/sge/bin/common"

_qstat_out=$("${SGE_BINDIR}/qstat" -f -u "*" 2>&1)
_exit_code="$?"
if [ "${_exit_code}" != "0" ]; then
  ef_error "${_qstat_out} - exit code (${_exit_code})" \
    "EnginFrame GE Plugin Error" \
    "${SGE_BINDIR}/qstat -f -u \"*\""
  exit ${_exit_code}
fi

echo "${_qstat_out}" | "${EF_AWK}" \
    -f "${EF_ROOT}/plugins/ef/lib/awk/utils.awk" \
    -f "${EF_ROOT}/plugins/sge/bin/list_queues_detailed.awk"


#
# vi: ts=4 sw=4 et syntax=sh :
#

