<?xml version="1.0" encoding="UTF-8"?>

<!--
Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
Copyright 1999-2023 by Nice, srl., All rights reserved.
This software includes confidential and proprietary information
of NI SP Software GmbH ("Confidential Information").
You shall not disclose such Confidential Information
and shall use it only in accordance with the terms of
the license agreement you entered into with NI SP Software.-->


<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:grid="http://www.enginframe.com/2000/GRID"
  >


  <xsl:template match="grid:job-list[@type='sge']">
    <grid:job-list type="sge">
      <xsl:apply-templates/>
    </grid:job-list>
  </xsl:template>


  <xsl:template match="job_list">
    <xsl:variable name="_jobid" select="JB_job_number"/>
    <grid:job type="sge" id="{$_jobid}">
      <xsl:apply-templates/>
    </grid:job>
  </xsl:template>


  <!-- Tag to remove -->
  <xsl:template match="JAT_prio"/>


  <!-- Tag to remove -->
  <xsl:template match="slots"/>


  <!-- Tag to remove -->
  <xsl:template match="JB_job_number"/>


  <xsl:template match="JB_name">
    <grid:name>
      <xsl:value-of select="text()"/>
    </grid:name>
  </xsl:template>


  <xsl:template match="JB_owner">
    <grid:owner>
      <xsl:value-of select="text()"/>
    </grid:owner>
  </xsl:template>


  <xsl:template match="JB_project">
    <grid:account>
      <xsl:value-of select="text()"/>
    </grid:account>
  </xsl:template>


  <xsl:template match="state">
    <grid:status>
      <xsl:choose>
        <xsl:when test="contains(text(), 'r')">RUN</xsl:when>
        <xsl:when test="contains(text(), 'R')">RUN</xsl:when>
        <xsl:when test="contains(text(), 'T')">RUN</xsl:when>
        <xsl:when test="contains(text(), 'w')">PEND</xsl:when>
        <xsl:when test="contains(text(), 'q')">PEND</xsl:when>
        <xsl:when test="contains(text(), 'd')">EXIT</xsl:when>
        <xsl:when test="contains(text(), 'E')">EXIT</xsl:when>
        <xsl:when test="contains(text(), 'h')">HOLD</xsl:when>
        <xsl:when test="contains(text(), 's')">USUSP</xsl:when>
        <xsl:when test="contains(text(), 'S')">SSUSP</xsl:when>
        <xsl:when test="contains(text(), 't')">SSUSP</xsl:when>
        <xsl:otherwise>UNKNWN</xsl:otherwise>
      </xsl:choose>
    </grid:status>
  </xsl:template>


  <xsl:template match="queue_name">
    <grid:queue>
      <xsl:value-of select="substring-before(text(),'@')"/>
    </grid:queue>
    <grid:execution-host>
      <xsl:value-of select="substring-after(text(),'@')"/>
    </grid:execution-host>
  </xsl:template>


  <xsl:template match="JAT_start_time">
    <grid:execution-time>
      <xsl:value-of select="text()"/>
    </grid:execution-time>
  </xsl:template>


  <xsl:template match="*|@*">
    <xsl:copy-of select="."/>
  </xsl:template>


</xsl:stylesheet>


<!--
# vi: ts=2 sw=2 et syntax=xslt :
-->

