<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
    xmlns:grid="http://www.enginframe.com/2000/GRID"
    xmlns:func="http://exslt.org/functions"
    extension-element-prefixes="date func ef">

<xsl:include href="${EF_ROOT}/plugins/grid/lib/xsl/grid.filter.library.xsl" />

<date:month-lengths>
   <date:month>31</date:month>
   <date:month>28</date:month>
   <date:month>31</date:month>
   <date:month>30</date:month>
   <date:month>31</date:month>
   <date:month>30</date:month>
   <date:month>31</date:month>
   <date:month>31</date:month>
   <date:month>30</date:month>
   <date:month>31</date:month>
   <date:month>30</date:month>
   <date:month>31</date:month>
</date:month-lengths>

<xsl:variable name="add_or_sub" select="substring($timezone, 1, 1)" />
<xsl:variable name="offset_hours" select="substring($timezone, 2, 2)" />
<xsl:variable name="offset_minutes" select="substring($timezone, 5, 2)" />
<xsl:variable name="offset" select="number($offset_hours) * 3600 + number($offset_minutes) * 60" />

<func:function name="ef:add">
   <xsl:param name="date-time"/>
   <xsl:param name="duration"/>
   <xsl:variable name="dt-neg" select="starts-with($date-time, '-')"/>
   <xsl:variable name="dt-no-neg">
      <xsl:choose>
         <xsl:when test="$dt-neg or starts-with($date-time, '+')">
            <xsl:value-of select="substring($date-time, 2)"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$date-time"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:variable>
   <xsl:variable name="dt-no-neg-length" select="string-length($dt-no-neg)"/>
   <xsl:variable name="timezone">
      <xsl:choose>
         <xsl:when test="substring($dt-no-neg, $dt-no-neg-length) = 'Z'">Z</xsl:when>
         <xsl:otherwise>
            <xsl:variable name="tz" select="substring($dt-no-neg, $dt-no-neg-length - 5)"/>
            <xsl:if test="(substring($tz, 1, 1) = '-' or substring($tz, 1, 1) = '+') and substring($tz, 4, 1) = ':'">
               <xsl:value-of select="$tz"/>
            </xsl:if>
         </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
   <xsl:variable name="new-dt">
     <xsl:if test="not(string($timezone)) or $timezone = 'Z' or (substring($timezone, 2, 2) &lt;= 23 and substring($timezone, 5, 2) &lt;= 59)">
       <xsl:variable name="dt" select="substring($dt-no-neg, 1, $dt-no-neg-length - string-length($timezone))"/>
       <xsl:variable name="dt-length" select="string-length($dt)"/>
       <xsl:variable name="du-neg" select="starts-with($duration, '-')"/>
       <xsl:variable name="du">
          <xsl:choose>
             <xsl:when test="$du-neg"><xsl:value-of select="substring($duration, 2)"/></xsl:when>
             <xsl:otherwise><xsl:value-of select="$duration"/></xsl:otherwise>
          </xsl:choose>
       </xsl:variable>
       <xsl:if test="starts-with($du, 'P') and not(translate($du, '0123456789PYMDTHS.', ''))">
          <xsl:variable name="du-date">
             <xsl:choose>
                <xsl:when test="contains($du, 'T')"><xsl:value-of select="substring-before(substring($du, 2), 'T')"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="substring($du, 2)"/></xsl:otherwise>
             </xsl:choose>
          </xsl:variable>
          <xsl:variable name="du-time">
             <xsl:if test="contains($du, 'T')"><xsl:value-of select="substring-after($du, 'T')"/></xsl:if>
          </xsl:variable>
          <xsl:if test="(not($du-date) or(not(translate($du-date, '0123456789YMD', '')) and not(substring-after($du-date, 'D')) and (contains($du-date, 'D') or (not(substring-after($du-date, 'M')) and (contains($du-date, 'M') or not(substring-after($du-date, 'Y'))))))) and (not($du-time) or(not(translate($du-time, '0123456789HMS.', '')) and not(substring-after($du-time, 'S')) and (contains($du-time, 'S') or not(substring-after($du-time, 'M')) and (contains($du-time, 'M') or not(substring-after($du-time, 'Y'))))))">
             <xsl:variable name="duy-str">
                <xsl:choose>
                   <xsl:when test="contains($du-date, 'Y')"><xsl:value-of select="substring-before($du-date, 'Y')"/></xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>
             </xsl:variable>
             <xsl:variable name="dum-str">
                <xsl:choose>
                   <xsl:when test="contains($du-date, 'M')">
                      <xsl:choose>
                         <xsl:when test="contains($du-date, 'Y')"><xsl:value-of select="substring-before(substring-after($du-date, 'Y'), 'M')"/></xsl:when>
                         <xsl:otherwise><xsl:value-of select="substring-before($du-date, 'M')"/></xsl:otherwise>
                      </xsl:choose>
                   </xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>
             </xsl:variable>
             <xsl:variable name="dud-str">
                <xsl:choose>
                   <xsl:when test="contains($du-date, 'D')">
                      <xsl:choose>
                         <xsl:when test="contains($du-date, 'M')"><xsl:value-of select="substring-before(substring-after($du-date, 'M'), 'D')"/></xsl:when>
                         <xsl:when test="contains($du-date, 'Y')"><xsl:value-of select="substring-before(substring-after($du-date, 'Y'), 'D')"/></xsl:when>
                         <xsl:otherwise><xsl:value-of select="substring-before($du-date, 'D')"/></xsl:otherwise>
                      </xsl:choose>
                   </xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>
             </xsl:variable>
             <xsl:variable name="duh-str">
                <xsl:choose>
                   <xsl:when test="contains($du-time, 'H')"><xsl:value-of select="substring-before($du-time, 'H')"/></xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>
             </xsl:variable>
             <xsl:variable name="dumin-str">
                <xsl:choose>
                   <xsl:when test="contains($du-time, 'M')">
                      <xsl:choose>
                         <xsl:when test="contains($du-time, 'H')"><xsl:value-of select="substring-before(substring-after($du-time, 'H'), 'M')"/></xsl:when>
                         <xsl:otherwise><xsl:value-of select="substring-before($du-time, 'M')"/></xsl:otherwise>
                      </xsl:choose>
                   </xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>
             </xsl:variable>
             <xsl:variable name="dus-str">
                <xsl:choose>
                   <xsl:when test="contains($du-time, 'S')">
                      <xsl:choose>
                         <xsl:when test="contains($du-time, 'M')"><xsl:value-of select="substring-before(substring-after($du-time, 'M'), 'S')"/></xsl:when>
                         <xsl:when test="contains($du-time, 'H')"><xsl:value-of select="substring-before(substring-after($du-time, 'H'), 'S')"/></xsl:when>
                         <xsl:otherwise><xsl:value-of select="substring-before($du-time, 'S')"/></xsl:otherwise>
                      </xsl:choose>
                   </xsl:when>
                   <xsl:otherwise>0</xsl:otherwise>
                </xsl:choose>
             </xsl:variable>
             <xsl:variable name="mult" select="($du-neg * -2) + 1"/>
             <xsl:variable name="duy" select="$duy-str * $mult"/>
             <xsl:variable name="dum" select="$dum-str * $mult"/>
             <xsl:variable name="dud" select="$dud-str * $mult"/>
             <xsl:variable name="duh" select="$duh-str * $mult"/>
             <xsl:variable name="dumin" select="$dumin-str * $mult"/>
             <xsl:variable name="dus" select="$dus-str * $mult"/>

             <xsl:variable name="year" select="substring($dt, 1, 4) * (($dt-neg * -2) + 1)"/>
             <xsl:choose>
                <xsl:when test="$year and string($duy) = 'NaN' or string($dum) = 'NaN' or string($dud) = 'NaN' or string($duh) = 'NaN' or string($dumin) = 'NaN' or string($dus) = 'NaN'"/>
                <xsl:when test="$dt-length &gt; 4 or $dum or $dud or $duh or $dumin or $dus">
                   <xsl:variable name="month">
                      <xsl:choose>
                         <xsl:when test="$dt-length &gt; 4">
                            <xsl:if test="substring($dt, 5, 1) = '-'">
                               <xsl:value-of select="substring($dt, 6, 2)"/>
                            </xsl:if>
                         </xsl:when>
                         <xsl:otherwise>1</xsl:otherwise>
                      </xsl:choose>
                   </xsl:variable>
                   <xsl:choose>
                      <xsl:when test="not($month) or $month &gt; 12"/>
                      <xsl:when test="$dt-length &gt; 7 or $dud or $duh or $dumin or $dus">
                        <xsl:variable name="day">
                          <xsl:choose>
                            <xsl:when test="$dt-length &gt; 7">
                              <xsl:if test="substring($dt, 8, 1) = '-'">
                                 <xsl:value-of select="substring($dt, 9, 2)"/>
                              </xsl:if>
                            </xsl:when>
                            <xsl:otherwise>1</xsl:otherwise>
                          </xsl:choose>
                        </xsl:variable>
                        <xsl:choose>
                          <xsl:when test="not($day) or $day &gt; 31"/>
                          <xsl:when test="$dt-length &gt; 10 or $duh or $dumin or $dus">
                            <xsl:if test="$dt-length = 10 or (substring($dt, 11, 1) = 'T' and substring($dt, 14, 1) = ':' and substring($dt, 17, 1) = ':')">
                              <xsl:variable name="hour">
                                <xsl:choose>
                                  <xsl:when test="$dt-length &gt; 10"><xsl:value-of select="substring($dt, 12, 2)"/></xsl:when>
                                  <xsl:otherwise>0</xsl:otherwise>
                                </xsl:choose>
                              </xsl:variable>
                              <xsl:variable name="minute">
                                <xsl:choose>
                                  <xsl:when test="$dt-length &gt; 10"><xsl:value-of select="substring($dt, 15, 2)"/></xsl:when>
                                  <xsl:otherwise>0</xsl:otherwise>
                                </xsl:choose>
                              </xsl:variable>
                              <xsl:variable name="second">
                                <xsl:choose>
                                  <xsl:when test="$dt-length &gt; 10"><xsl:value-of select="substring($dt, 18)"/></xsl:when>
                                  <xsl:otherwise>0</xsl:otherwise>
                                </xsl:choose>
                              </xsl:variable>
                              <xsl:if test="$hour &lt;= 23 and $minute &lt;= 59 and $second &lt;= 60">
                                 <xsl:variable name="new-second" select="$second + $dus"/>
                                 <xsl:variable name="new-minute" select="$minute + $dumin + floor($new-second div 60)"/>
                                 <xsl:variable name="new-hour" select="$hour + $duh + floor($new-minute div 60)"/>
                                 <xsl:variable name="new-month" select="$month + $dum"/>
                                 <xsl:call-template name="ef:_add-days">
                                    <xsl:with-param name="year" select="$year + $duy + floor(($new-month - 1) div 12)"/>
                                    <xsl:with-param name="month">
                                       <xsl:variable name="m">
                                          <xsl:choose>
                                             <xsl:when test="$new-month &lt; 1"><xsl:value-of select="$new-month + 12"/></xsl:when>
                                             <xsl:otherwise><xsl:value-of select="$new-month"/></xsl:otherwise>
                                          </xsl:choose>
                                       </xsl:variable>
                                       <xsl:choose>
                                          <xsl:when test="$m mod 12">
                                             <xsl:value-of select="format-number($m mod 12, '00')"/>
                                          </xsl:when>
                                          <xsl:otherwise>12</xsl:otherwise>
                                       </xsl:choose>
                                    </xsl:with-param>
                                    <xsl:with-param name="day" select="$day"/>
                                    <xsl:with-param name="days" select="$dud + floor($new-hour div 24)"/>
                                 </xsl:call-template>
                                 <xsl:text>T</xsl:text>
                                 <xsl:value-of select="format-number(($new-hour + 24) mod 24, '00')"/>
                                 <xsl:text>:</xsl:text>
                                 <xsl:value-of select="format-number($new-minute mod 60, '00')"/>
                                 <xsl:text>:</xsl:text>
                                 <xsl:if test="$new-second mod 60 &lt; 10">0</xsl:if>
                                 <xsl:value-of select="$new-second mod 60"/>
                                 <xsl:value-of select="$timezone"/>
                              </xsl:if>
                            </xsl:if>
                          </xsl:when>
                        <xsl:otherwise>
                           <xsl:variable name="new-month" select="$month + $dum"/>
                           <xsl:call-template name="ef:_add-days">
                        <xsl:with-param name="year" select="$year + $duy + floor(($new-month - 1) div 12)"/>
                        <xsl:with-param name="month">
                           <xsl:variable name="m">
                              <xsl:choose>
                                 <xsl:when test="$new-month &lt; 1"><xsl:value-of select="$new-month + 12"/></xsl:when>
                                 <xsl:otherwise><xsl:value-of select="$new-month"/></xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                           <xsl:choose>
                              <xsl:when test="$m mod 12">
                                 <xsl:value-of select="format-number($m mod 12, '00')"/>
                              </xsl:when>
                              <xsl:otherwise>12</xsl:otherwise>
                           </xsl:choose>
                        </xsl:with-param>
                        <xsl:with-param name="day" select="$day"/>
                        <xsl:with-param name="days" select="$dud"/>
                           </xsl:call-template>
                           <xsl:value-of select="$timezone"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:when>
              <xsl:otherwise>
                 <xsl:variable name="new-month" select="$month + $dum"/>
                 <xsl:value-of select="format-number($year + $duy + floor(($new-month - 1) div 12), '0000')"/>
                 <xsl:text>-</xsl:text>
                 <xsl:variable name="m">
                <xsl:choose>
                   <xsl:when test="$new-month &lt; 1"><xsl:value-of select="$new-month + 12"/></xsl:when>
                   <xsl:otherwise><xsl:value-of select="$new-month"/></xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:choose>
                <xsl:when test="$m mod 12">
                   <xsl:value-of select="format-number($m mod 12, '00')"/>
                </xsl:when>
                   <xsl:otherwise>12</xsl:otherwise>
                 </xsl:choose>
                  <xsl:value-of select="$timezone"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="format-number($year + $duy, '0000')"/>
              <xsl:value-of select="$timezone"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </xsl:if>
    </xsl:if>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="string-length($date-time) &gt; 10">
      <func:result select="$new-dt"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="substring($new-dt, 1, string-length($date-time))"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<xsl:template name="ef:_add-days">
   <xsl:param name="year"/>
   <xsl:param name="month"/>
   <xsl:param name="day"/>
   <xsl:param name="days"/>
   <xsl:param name="new-day" select="'NaN'"/>
   <xsl:variable name="leap" select="(not($year mod 4) and $year mod 100) or not($year mod 400)"/>
   <xsl:variable name="month-days" select="document('')/*/date:month-lengths/date:month"/>
   <xsl:variable name="days-in-month">
      <xsl:choose>
         <xsl:when test="$month = 2 and $leap">
            <xsl:value-of select="$month-days[number($month)] + 1"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$month-days[number($month)]"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:variable>
   <xsl:choose>
      <xsl:when test="$new-day = 'NaN'">
         <xsl:call-template name="ef:_add-days">
            <xsl:with-param name="year" select="$year"/>
            <xsl:with-param name="month" select="$month"/>
            <xsl:with-param name="new-day">
               <xsl:choose>
                  <xsl:when test="$day &gt; $days-in-month">
                     <xsl:value-of select="$days-in-month + $days"/>
                  </xsl:when>
                  <xsl:otherwise><xsl:value-of select="$day + $days"/></xsl:otherwise>
               </xsl:choose>
            </xsl:with-param>
         </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
         <xsl:choose>
            <xsl:when test="$new-day &lt; 1">
               <xsl:call-template name="ef:_add-days">
                  <xsl:with-param name="year" select="$year - ($month = 1)"/>
                  <xsl:with-param name="month">
                     <xsl:choose>
                        <xsl:when test="$month = 1">12</xsl:when>
                        <xsl:otherwise><xsl:value-of select="$month - 1"/></xsl:otherwise>
                     </xsl:choose>
                  </xsl:with-param>
                  <xsl:with-param name="new-day">
                     <xsl:variable name="days-in-new-month">
                        <xsl:choose>
                           <xsl:when test="$leap and $month = 3">29</xsl:when>
                           <xsl:when test="$month = 1">31</xsl:when>
                           <xsl:otherwise>
                             <xsl:value-of select="$month-days[$month - 1]"/>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:variable>
                     <xsl:value-of select="$new-day + $days-in-new-month"/>
                  </xsl:with-param>
               </xsl:call-template>
            </xsl:when>
            <xsl:when test="$new-day &gt; $days-in-month">
               <xsl:call-template name="ef:_add-days">
                  <xsl:with-param name="year" select="$year + ($month = 12)"/>
                  <xsl:with-param name="month">
                     <xsl:choose>
                        <xsl:when test="$month = 12">1</xsl:when>
                        <xsl:otherwise><xsl:value-of select="$month + 1"/></xsl:otherwise>
                     </xsl:choose>
                  </xsl:with-param>
                  <xsl:with-param name="new-day" select="$new-day - $days-in-month"/>
               </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="format-number($year, '0000')"/>
               <xsl:text>-</xsl:text>
               <xsl:value-of select="format-number($month, '00')"/>
               <xsl:text>-</xsl:text>
               <xsl:value-of select="format-number($new-day, '00')"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<func:function name="ef:duration">
   <xsl:param name="seconds">
      <xsl:choose>
         <xsl:when test="function-available('date:seconds')">
            <xsl:value-of select="date:seconds()"/>
         </xsl:when>
         <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
   </xsl:param>
   <xsl:variable name="duration">
      <xsl:variable name="day-s" select="60 * 60 * 24"/>
      <xsl:variable name="hour-s" select="60 * 60"/>
      <xsl:variable name="min-s" select="60"/>
      <xsl:if test="$seconds &lt; 0">-</xsl:if>
      <xsl:text>P</xsl:text>
      <xsl:variable name="s" select="$seconds * ((($seconds &gt;= 0) * 2) - 1)"/>
      <xsl:variable name="days" select="floor($s div $day-s)"/>
      <xsl:variable name="hours" select="floor(($s - ($days * $day-s)) div $hour-s)"/>
      <xsl:variable name="mins" select="floor(($s - ($days * $day-s) - ($hours * $hour-s)) div $min-s)"/>
      <xsl:variable name="secs" select="$s - ($days * $day-s) - ($hours * $hour-s) - ($mins * $min-s)"/>
      <xsl:if test="$days">
         <xsl:value-of select="$days"/>
         <xsl:text>D</xsl:text>
      </xsl:if>
      <xsl:if test="$hours or $mins or $secs">T</xsl:if>
      <xsl:if test="$hours">
         <xsl:value-of select="$hours"/>
         <xsl:text>H</xsl:text>
      </xsl:if>
      <xsl:if test="$mins">
         <xsl:value-of select="$mins"/>
         <xsl:text>M</xsl:text>
      </xsl:if>
      <xsl:if test="$secs">
         <xsl:value-of select="$secs"/>
         <xsl:text>S</xsl:text>
      </xsl:if>
   </xsl:variable>
   <func:result select="string($duration)"/>
</func:function>

<xsl:template match="/">
    <xsl:apply-templates />
</xsl:template>

<xsl:variable name="comp_array" select="grid:brief-job-list/@compress" />
<xsl:variable name="user" select="grid:brief-job-list/@user" />

<xsl:template match="grid:brief-job-list">
     <grid:job-list type="sge" cluster="{@cluster}" xmlns:grid="http://www.enginframe.com/2000/GRID">
         <xsl:apply-templates />
     </grid:job-list>
</xsl:template>

<xsl:template match="detailed_job_info">
     <xsl:apply-templates />
</xsl:template>

<xsl:template match="djob_info">
     <xsl:apply-templates select="element[./JB_owner = $user or ./JB_owner/text() = *[$user = 'all'] or $user = '' ]" />
</xsl:template>

<xsl:template match="element">
    <xsl:choose>
      <xsl:when test="JB_job_number">
        <xsl:variable name="num_of_tasks" select="JB_ja_structure/element/RN_max"/>
        <xsl:variable name="jobid">
          <xsl:choose>
            <xsl:when test="$num_of_tasks &gt; 1"><xsl:value-of select="JB_job_number" /></xsl:when>
            <xsl:otherwise><xsl:value-of select="JB_job_number" /></xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="jobname">
          <xsl:choose>
            <xsl:when test="$num_of_tasks &gt; 1"><xsl:value-of select="JB_job_name"/>[<xsl:value-of select="$num_of_tasks"/>]</xsl:when>
            <xsl:otherwise><xsl:value-of select="JB_job_name"/></xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="isarray">
          <xsl:choose>
            <xsl:when test="$num_of_tasks &gt; 1">true</xsl:when>
            <xsl:otherwise></xsl:otherwise>
          </xsl:choose>
        </xsl:variable>

        <grid:job type="sge" id="{$jobid}" is-array="{$isarray}">
          <grid:name><xsl:value-of select="$jobname"/></grid:name>
          <grid:owner><xsl:value-of select="JB_owner"/></grid:owner>
          <grid:account><xsl:value-of select="JB_account"/></grid:account>
          <grid:command><xsl:value-of select="JB_script_file"/></grid:command>
          <grid:execution-directory><xsl:value-of select="JB_cwd"/></grid:execution-directory>

          <xsl:variable name="norm_sub_time">
            <xsl:choose>
              <xsl:when test="$add_or_sub = '+'">
                 <xsl:value-of select="ef:duration(number(substring(JB_submission_time, 1, 10)) + $offset)" />
              </xsl:when>
              <xsl:otherwise>
                 <xsl:value-of select="ef:duration(number(substring(JB_submission_time, 1, 10)) - $offset)" />
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>

          <xsl:variable name="sub_t" select="ef:add('1970-01-01T00:00:00', $norm_sub_time)"/>
          <xsl:variable name="sub_t_mon" select="date:month-abbreviation($sub_t)"/>
          <xsl:variable name="sub_t_day" select="substring($sub_t,9,2)"/>
          <xsl:variable name="sub_t_hour" select="substring($sub_t,12,2)"/>
          <xsl:variable name="sub_t_min" select="substring($sub_t,15,2)"/>
          <xsl:variable name="sub_t_year" select="substring($sub_t,1,4)"/>

          <grid:submission-time month="{$sub_t_mon}" day="{$sub_t_day}" hour="{$sub_t_hour}" minute="{$sub_t_min}" year="{$sub_t_year}"/>
          <grid:submission-host><xsl:value-of select="JB_env_list/element/VA_value[../VA_variable/text() = '__SGE_PREFIX__O_HOST']"/></grid:submission-host>
          <grid:submission-directory><xsl:value-of select="JB_env_list/element/VA_value[../VA_variable/text() = '__SGE_PREFIX__O_WORKDIR']"/></grid:submission-directory>

          <xsl:choose>
            <xsl:when test="$num_of_tasks &gt; 1 or $comp_array = 'true'">

              <xsl:variable name="queue_inst">
                <xsl:choose>
                  <xsl:when test="JB_ja_tasks/ulong_sublist[1]/JAT_granted_destin_identifier_list/element/JG_qname">
                     <xsl:value-of select="JB_ja_tasks/ulong_sublist[1]/JAT_granted_destin_identifier_list/element/JG_qname"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:value-of select="JB_ja_tasks/element/JAT_granted_destin_identifier_list/element/JG_qname"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <grid:queue><xsl:value-of select="substring-before($queue_inst,'@')"/></grid:queue>

              <grid:array-status>
                <xsl:variable name="running" select="count(JB_ja_tasks/ulong_sublist[JAT_status = '128']) + count(JB_ja_tasks/element[JAT_status = '128'])"/>
                <xsl:variable name="error" select="count(JB_ja_tasks/ulong_sublist[JAT_status = '0']) + count(JB_ja_tasks/element[JAT_status = '0'])"/>
                <grid:counter ef="" grid="NJOBS"><xsl:value-of select="$num_of_tasks" /></grid:counter>
                <grid:counter ef="Done" grid="DONE">0</grid:counter>
                <grid:counter ef="Running" grid="RUN"><xsl:value-of select="$running"/></grid:counter>
                <grid:counter ef="Exit" grid="EXIT"><xsl:value-of select="$error"/></grid:counter>
                <grid:counter ef="Interrupted" grid="SSUSP">0</grid:counter>
                <grid:counter ef="Suspended" grid="USUSP">0</grid:counter>
              </grid:array-status>
            </xsl:when>
            <xsl:otherwise>
              <xsl:if test="not(JB_ja_tasks/element/JAT_status) and not(JB_ja_tasks/ulong_sublist/JAT_status) and not(JB_ja_tasks/element/JAT_status) and not(JB_ja_tasks/element/JAT_status)">
                 <grid:status grid="qw" ef="Pending">PEND</grid:status>
              </xsl:if>
              <xsl:apply-templates select="JB_ja_tasks | ulong_sublist | JAT_granted_destin_identifier_list | JAT_status | JG_qname | JG_qhostname | JAT_scaled_usage_list | element" />
            </xsl:otherwise>
          </xsl:choose>

        </grid:job>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="JB_ja_tasks | ulong_sublist | JAT_granted_destin_identifier_list | JAT_status | JG_qname | JG_qhostname | JAT_scaled_usage_list | element" />
      </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="JB_ja_tasks">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="ulong_sublist">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="JAT_granted_destin_identifier_list">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="JAT_status">
    <xsl:choose>
      <xsl:when test="text() = 128">

        <xsl:variable name="norm_start_time">
          <xsl:choose>
            <xsl:when test="$add_or_sub = '+'">
                <xsl:choose>
                  <xsl:when test="JB_ja_tasks/ulong_sublist/JAT_start_time">
                    <xsl:value-of select="ef:duration(number(substring(JB_ja_tasks/ulong_sublist/JAT_start_time, 1, 10)) + $offset)" />
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="ef:duration(number(substring(JB_ja_tasks/element/JAT_start_time, 1, 10)) + $offset)" />
                  </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                  <xsl:when test="JB_ja_tasks/ulong_sublist/JAT_start_time">
                    <xsl:value-of select="ef:duration(number(substring(JB_ja_tasks/ulong_sublist/JAT_start_time, 1, 10)) - $offset)" />
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="ef:duration(number(substring(JB_ja_tasks/element/JAT_start_time, 1, 10)) - $offset)" />
                  </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="start_t" select="ef:add('1970-01-01T00:00:00', $norm_start_time)"/>
        <xsl:variable name="start_t_mon" select="date:month-abbreviation($start_t)"/>
        <xsl:variable name="start_t_day" select="substring($start_t,9,2)"/>
        <xsl:variable name="start_t_hour" select="substring($start_t,12,2)"/>
        <xsl:variable name="start_t_min" select="substring($start_t,15,2)"/>
        <xsl:variable name="start_t_year" select="substring($start_t,1,4)"/>

        <grid:execution-time month="{$start_t_mon}" day="{$start_t_day}" hour="{$start_t_hour}" minute="{$start_t_min}" year="{$start_t_year}"/>
        <grid:status grid="r" ef="Running">RUN</grid:status>
      </xsl:when>

      <xsl:when test="text() = 0">
        <grid:status grid="Eqw" ef="Exit">EXIT</grid:status>
      </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template match="JG_qname">
    <grid:queue><xsl:value-of select="."/></grid:queue>
</xsl:template>

<xsl:template match="JG_qhostname">
    <grid:execution-host><xsl:value-of select="."/></grid:execution-host>
</xsl:template>

<xsl:template match="JAT_scaled_usage_list">
    <grid:total-cpu-usage><xsl:value-of select="scaled/UA_value[../UA_name/text() = 'cpu']"/></grid:total-cpu-usage>
    <grid:memory-usage><xsl:value-of select="substring-before(scaled/UA_value[../UA_name/text() = 'maxvmem'], '.')"/></grid:memory-usage>
</xsl:template>

<xsl:template match="messages|reservations" />

<xsl:template match="*|@*">
  <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>

