################################################################################
# Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
# Copyright 1999-2023 by Nice, srl., All rights reserved.
#
# This software includes confidential and proprietary information
# of NI SP Software GmbH ("Confidential Information").
# You shall not disclose such Confidential Information
# and shall use it only in accordance with the terms of
# the license agreement you entered into with NI SP Software.
################################################################################

BEGIN {
    first = 1; isGridAccountSet = 0; FS=" ";

    # Read status mapping file
    while (getline < statusmap > 0) {
        split($0,fields,":");
        s = split(fields[2],label," ");
        for (i=1;i<=s;i++) {
            states[label[i]]=fields[1]
        }
    }
    close(statusmap);
}

END {
    if (!first) {
        if (gridStatus=="PENDING" && (REASON=="JobHeldUser" || REASON=="JobHeldAdmin")) {
            efStatus="Suspended"
            status="HOLD"
        }
        print "    <grid:status grid=\"" gridStatus "\" ef=\"" efStatus "\">" status "</grid:status>";
        print "  </grid:job>";
    }
}

#JobId=%i
#JobName=%j
#UserId=%u
#Partition=%P
#RunTime=%M
#MinMemoryNode=%m
#MinTmpDiskNode=%d
#JobState=%T
#NodeList=%N
#SubmitTime=%V
#StartTime=%S
#NumCPUs=%C
#Project=%k
#Account=%a
#WorkDir=%Z
#Nice=%y
#Reason=%r

/^JobId=/ {
    if (!first) {
        # job array case
        if (gridStatus=="PENDING" && (REASON=="JobHeldUser" || REASON=="JobHeldAdmin")) {
            efStatus="Suspended"
            status="HOLD"
        }
        print "    <grid:status grid=\"" gridStatus "\" ef=\"" efStatus "\">" status "</grid:status>";
        print "  </grid:job>";
    }
    clearVars();
    first = 0;
    split($0,jobid,"=");
    print "  <grid:job type=\"slurm\" id=\"" jobid[2] "\">"
}

/^JobName=/ {
    split(escapeXmlContent($0),jobname,"=");
    print "    <grid:name>" jobname[2] "</grid:name>";
    _EF_JOB_NAME = jobname[2]
}

/^UserId=/ {
    split($0,userdata,"=");
    split(userdata[2],owner,"(");
    print "    <grid:owner>" escapeXmlContent(owner[1]) "</grid:owner>"
    #print "    <grid:submission-host>" escapeXmlContent(userdata[2]) "</grid:submission-host>"
}

/^Partition=/ {
    split($0,queue,"=");
    print "    <grid:queue>" escapeXmlContent(queue[2]) "</grid:queue>"
}

/^RunTime=/ {
    split($0,runtime,"=");
    print "    <grid:total-cpu-usage>" runtime[2] "</grid:total-cpu-usage>"
}

/^MinMemoryNode=/ {
    split($0,minmemorynode,"=");
    print "    <grid:memory-usage>" minmemorynode[2] "</grid:memory-usage>"
}

/^MinTmpDiskNode=/ {
    split($0,mintmpdisknode,"=");
    print "    <grid:swap-usage>" mintmpdisknode[2] "</grid:swap-usage>"
}

/^JobState=/ {
    split($0,jobstate,"=");
    # EF 2013 Job status mapping
    efStatus = states[jobstate[2]];
    if (efStatus=="") efStatus = "Unknown"

    if (match(jobstate[2], "PENDING")) status = "PEND"
    else if (match(jobstate[2], "CONFIGURING")) status = "PEND"
    else if (match(jobstate[2], "RUNNING")) status = "RUN"
    else if (match(jobstate[2], "COMPLETING")) status = "RUN"
    else if (match(jobstate[2], "SUSPENDED")) status = "PSUSP"
    else if (match(jobstate[2], "FAILED")) status = "EXIT"
    else if (match(jobstate[2], "CANCELLED")) status = "EXIT"
    else if (match(jobstate[2], "COMPLETED")) status = "DONE"
    else status = "UNKNWN"

    # SLURM job status
    gridStatus = jobstate[2]
}

/^NodeList=/ {
    split($0, nodelist, "=")
    split(nodelist[2], h, ",")
    for (i in h) {
        gsub(/\/.*$/, "", h[i])
        print "    <grid:execution-host>" escapeXmlContent(h[i]) "</grid:execution-host>"
    }
}

/^SubmitTime=/ {
    split($0, submittime, "=");
    split(submittime[2], event, "T");
    split(event[1], eventdate, "-");
    split(event[2], eventtime, ":");
    timestamp = "month=\"" eventdate[2] "\" day=\"" eventdate[3] "\" hour=\"" eventtime[1] \
        "\" minute=\"" eventtime[2] "\" year=\"" eventdate[1] "\""
    print "    <grid:submission-time " timestamp ">" submittime[2] "</grid:submission-time>"
}

/^StartTime=/ {
    split($0, starttime, "=");
    split(starttime[2], event, "T");
    split(event[1], eventdate, "-");
    split(event[2], eventtime, ":");
    timestamp = "month=\"" eventdate[2] "\" day=\"" eventdate[3] "\" hour=\"" eventtime[1] \
        "\" minute=\"" eventtime[2] "\" year=\"" eventdate[1] "\""
    print "    <grid:execution-time " timestamp ">" starttime[2] "</grid:execution-time>"
}

/^EndTime=/ {
    split($0, endtime, "=");
    split(endtime[2], event, "T");
    split(event[1], eventdate, "-");
    split(event[2], eventtime, ":");
    timestamp = "month=\"" eventdate[2] "\" day=\"" eventdate[3] "\" hour=\"" eventtime[1] \
        "\" minute=\"" eventtime[2] "\" year=\"" eventdate[1] "\""
    print "    <grid:termination-time " timestamp ">" endtime[2] "</grid:termination-time>"
}

/^NumCPUs=/ {
    split($0, numcpus, "=");
    print "    <grid:parallel min=\"" numcpus[2] "\" max=\"" numcpus[2] "\"/>"
}

/^Project=/ {
    split($0, project, "=");
    if (length(project[2]) != 0 && project[2] != "(null)" && !isGridAccountSet) {
        print "    <grid:account>" escapeXmlContent(project[2]) "</grid:account>";
        isGridAccountSet = 1;
    }
}

/^Account=/ {
    split($0, account, "=");
    if (length(account[2]) != 0 && account[2] != "(null)" && !isGridAccountSet) {
        print "    <grid:account>" escapeXmlContent(account[2]) "</grid:account>";
        isGridAccountSet = 1;
    }
}

/^WorkDir=/ {
    split($0, pathdata, "=")
    print "    <grid:execution-directory>" escapeXmlContent(pathdata[2]) "</grid:execution-directory>"
}

/^Nice=/ {
    split($0, nice, "=")
    print "    <grid:nice>" escapeXmlContent(nice[2]) "</grid:nice>"
}

/^Reason=/ {
    split($0,reason,"=");
    print "    <grid:reasons>"
    print "      <grid:reason>" escapeXmlContent(reason[2]) "</grid:reason>"
    print "    </grid:reasons>"
    REASON=reason[2]
}

function clearVars() {
    REASON=""
}

# ex:ts=4:sw=4:et:
