DELETE FROM UGM_USER;

DROP TABLE UGM_USER;

CREATE TABLE UGM_USER (
  userName VARCHAR(255) NOT NULL CHECK (userName <> ''),
  upperUserName VARCHAR(255) NOT NULL,
  nameSpace VARCHAR(255) NOT NULL CHECK (nameSpace <> ''),
  upperNameSpace VARCHAR(255) NOT NULL,
  realName VARCHAR(255) DEFAULT NULL,
  lastLoginTime TIMESTAMP DEFAULT NULL,
  creationTime TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
  CONSTRAINT pk_userName_nameSpace PRIMARY KEY (userName, nameSpace),
  CONSTRAINT uq_userName_nameSpace
    UNIQUE (upperUserName, upperNameSpace)
  );

DELETE FROM UGM_MEMBERSHIP;

DROP TABLE UGM_MEMBERSHIP;

CREATE TABLE UGM_MEMBERSHIP (
  userName VARCHAR(255) NOT NULL,
  nameSpace VARCHAR(255) NOT NULL,
  groupName VARCHAR(255) NOT NULL CHECK (groupName <> ''),
  upperGroupName VARCHAR(255) NOT NULL,
  CONSTRAINT pk_userName_nS_groupName
    PRIMARY KEY (userName, nameSpace, groupName),
  CONSTRAINT uq_userName_nS_groupName
    UNIQUE (userName, nameSpace, upperGroupName),
  CONSTRAINT fk_group_user
    FOREIGN KEY (userName, nameSpace)
    REFERENCES UGM_USER (userName, nameSpace)
    ON DELETE CASCADE
  );
