/*global jQuery, hydrogenConf, document, window, location, wordcloud */
/*
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software. */
// The code depends from wordcloud/dynacloud plugin

var manageServices = {
    plugin: 'vdi',
    adminUri: '//vdi.admin/',
    adminSdf: '/' + jQuery.enginframe.rootContext + '/vdi/vdi.admin.xml',
    message: '#manage-services-message',

    refresh: function () {
        jQuery('#manage-services-table').hytable('reload');
    },

    init: function (id) {
        jQuery(document).ready(function () {
            var msg, toolbar, table, filters, projects, box, basefilter;
            var currentView = '';

            msg = jQuery('#' + id + '-message').hymessage();

            box = jQuery('#' + id + '-wrapper').collapsibleBox({
                cookieNamePrefix: id + '-box'
            });

            toolbar = jQuery('#' + id + '-toolbar').hytoolbar({
                conf: hydrogenConf[id],
                searchBoxHint: 'Search'
            });

            table = jQuery('#' + id + '-table').hytable({
                xmlreader: {
                    root: 'service-list',
                    row: 'service',
                    page: 'service-list>page',
                    total: 'service-list>total',
                    records: 'service-list>records',
                    repeatitems: false,
                    id: 'id' // id: '[uri]'
                },
                conf: hydrogenConf[id],
                messageArea: msg,
                defaultFilter: basefilter,
                defaultLoadErrorMessage: 'Cannot obtain the list of Services from the server.'
            });

            // Filters - begin
            filters = jQuery('#' + id + '-filters').hyfilters({
                conf: hydrogenConf[id]
            });
            // bind of 'hyfiltersselect' done by wordcloud plugin
            // Filters - end

            table.bind('hytablegridcomplete', function () {
                jQuery('td>div.hy-star').toggleStar();
                jQuery('td>span.hy-vtip').vtip();
                jQuery('.ef-manage-services-link').click(function (e) {
                    e.preventDefault();
                }).mouseup(function (e) {
                    e.preventDefault();
                    if (e.which === 2) {
                        // middle mouse button
                        manageServices.goEdit(jQuery(this).attr('data-service-id'), jQuery(this).attr('data-service-type'), "", true, true);
                    }
                    /*else if (e.which === 3) {
                        // right mouse button: do nothing
                    }*/
                    else {
                        manageServices.goEdit(jQuery(this).attr('data-service-id'), jQuery(this).attr('data-service-type'), "", true, false);
                    }
                    return false;
                });
            });

            // bind of 'hytableaction' done by wordcloud plugin

            table.bind('hytableselectionchanged', function (e, data) {
                toolbar.hytoolbar('viewProperties', {
                    'selected': table.hytable('selected').length
                });
            });

            // bind of 'hytoolbaraction' done by wordcloud plugin
            // bind of 'hytoolbarsearch' done by wordcloud plugin

            jQuery.hydrogen.setupAutoRefresh(id, hydrogenConf, manageServices.refresh);

            wordcloud.init({
                title: 'Availability',
                tableVar: 'manageServices',
                widgetId: id,
                toolbar: toolbar,
                table: table,
                filters: filters,
                searchCols: [ 'name', 'author', 'userGroups' ],
                filterKey: 'userGroups',
                refreshFunc: function () {
                    jQuery.enginframe.invokeService({
                        sdf: manageServices.adminSdf,
                        uri: manageServices.adminUri + 'list.' + manageServices.plugin + '.group.cloud',
                        dataType: "xml",
                        data: {
                            plugin: manageServices.plugin
                        },
                        success: function (xml) {
                            var data = '';
                            jQuery(xml).find('ef\\:option, option').each(function () {
                                jQuery.each(jQuery(this).text().split(","), function (index, value) {
                                    if (data !== '') {
                                        data += '\n';
                                    }
                                    data += value;
                                });
                            });
                            wordcloud.setData(data);
                        }
                    });
                }
            });
        });
    },

    formatter: {
        name: function (serviceName, opt, row) {
            var title, content = "";
            var encServiceName = efEncodeHtml(serviceName);

            if (jQuery(row).children("embeddable").text() === "true") {
                content += '<span class="ef-manage-services-embeddable"><i class="fa fa-code fa-lg"></i>&nbsp;</span>';
                title = 'The Service <strong>' + encServiceName + '</strong> is Embeddable into other Services (id=' + opt.rowId + ')';
            }
            else if (jQuery(row).children("type").text() === "interactive") {
                if (jQuery(row).children("os").text() === "windows") {
                    content += '<span class="ef-manage-services-interactive"><i class="fa fa-windows"></i>&nbsp;</span>';
                }
                if (jQuery(row).children("os").text() === "linux") {
                    content += '<span class="ef-manage-services-interactive"><i class="fa fa-linux"></i>&nbsp;</span>';
                }
                title = '<strong>' + encServiceName + '</strong> (id=' + opt.rowId + ')';
            }
            else {
                content += '<span class="ef-manage-services-batch"><i class="fa fa-cogs"></i>&nbsp;</span>';
                title = '<strong>' + encServiceName + '</strong> (id=' + opt.rowId + ')';
            }

            if (jQuery(row).attr("status") === "UNPUBLISHED" && jQuery(row).attr("locked") === "false") {
                content += "<a class='ef-manage-services-link' data-service-id='" + jQuery(row).attr("id") + "' data-service-type='" + jQuery(row).children("type").text() + "' >" + encServiceName + "</a>";
            }
            else {
                content += encServiceName;
            }
            return '<span class="hy-vtip" title="' + efEncodeHtml(title) + '">' + content + '</span>';
        },
        status: function (val, opt, row) {
                var st, cl;
                if (val === "PUBLISHED") {
                    st = "Published";
                    cl = "ef-service-published";
                } else if (val === "UNPUBLISHED") {
                    st = "Not published";
                    cl = "ef-service-unpublished";
                } else if (val === "ERROR") {
                    st = "Error";
                    cl = "ef-service-error";
                }
                return "<div class='" + cl + "'>" + st + "</div>";
            },
        locked: function (val, opt, row) {
                if (val === "true") {
                    return "<div class='ef-service-locked' title='The Service is locked for editing by " + jQuery(row).children("lockedBy").text().split('-')[0] + "'><i class='fa fa-lock fa-lg' ></i></div>";
                }
                else {
                    return "<div/>";
                }
            },
        os: function (val, opt, row) {
            var cl;
            var title = "Interactive Service";
            var windowsRegExp = /[Ww]indows/g;
            var linuxRegExp = /[Ll]inux/g;
            if (windowsRegExp.test(val)) {
                cl = "service-windows";
                val = '<i class="fa fa-windows" ></i>';
            } else if (linuxRegExp.test(val)) {
                cl = "service-linux";
                val = '<i class="fa fa-linux" ></i>';
            }
            return "<div class='" + cl + "' title='" + title + "'>" + val + "</div>";
        },
        lastModTime: function (val, opt, row)  {
            var modTime = jQuery(jQuery.hydrogen.prettyDateFormatter(val, opt)).text();
            return "<div>" + modTime + " by " + jQuery("lastModBy", row).text() + "</div>";
        },
        groups: function (val, opt, row) {
            if (typeof val === 'undefined') {
                val = "";
            }
            else {
                var userGroups = val.split(',');
                for (var i = 0; i < userGroups.length; i++) {
                    var group, name, encName, access;

                    group = userGroups[i];
                    if (group.indexOf(':') > -1) {
                        name = group.split(':')[0];
                        access = group.split(':')[1];
                    }
                    else {
                        name = group;
                        access = 'allow';
                    }
                    encName = efEncodeHtml(name);
                    userGroups[i] = "<div class='ef-service-group-tag ef-service-group-tag-" + access + "' title='" + encName + "'>" + encName + "</div>";
                }
                val = userGroups.join("");
            }
            return "<div class='" + manageServices.plugin + "-groups-list'>" + val + "</div>";
        }
    },

    goTestRun: function (serviceId) {
        var newWindow = window.open("", serviceId);

        jQuery.hydrogen.invokeService({
            sdf: manageServices.adminSdf,
            uri: '//com.enginframe.service-manager/get.service.xml',
            data: {
                serviceId: serviceId,
                plugin: manageServices.plugin
            },
            success: function (xml) {
                if (jQuery(xml).find('ef\\:option, option').length > 0 || jQuery(xml).find('ef\\:info, info').length > 0) {
                    newWindow.location.href = manageServices.adminSdf + '?_service=' + encodeURIComponent(serviceId) + '&testRun=true&navigation=manage.services';
                }
                else {
                    newWindow.location.href = manageServices.adminSdf + '?_uri=' + manageServices.adminUri + encodeURIComponent(serviceId) + '&testRun=true&navigation=manage.services';
                }
            }
        });
    },

    goDuplicate: function (serviceId, serviceName) {
        var msg, message;

        msg = jQuery(manageServices.message).hymessage();

        manageServices.simpleInputDialog("Duplicate", "New service name", "Duplicate", "Copy of " + serviceName, true, function (newName) {
            jQuery.hydrogen.invokeService({
                sdf: manageServices.adminSdf,
                uri: '//com.enginframe.service-manager/duplicate.service',
                data: {
                    serviceId: serviceId,
                    newServiceName: newName,
                    plugin: manageServices.plugin
                },
                success: function (xml) {
                    message = "The service '" + efEncodeHtml(serviceName) + "' has been duplicated to '" + efEncodeHtml(newName) + "'.";
                    msg.hymessage("info", message, 4000);
                    manageServices.refresh();
                },
                messagebox: msg
            });
        });
    },

    goEdit: function (serviceId, serviceType, templateId, checkServiceLock, openNewWindow) {
        var editorId, newWindow;

        editorId = Math.floor(Math.random() * 1000) + 1;
        newWindow = openNewWindow ? window.open("", serviceId) : window;

        if (checkServiceLock) {
            jQuery.hydrogen.invokeService({
                sdf: manageServices.adminSdf,
                uri: '//com.enginframe.service-manager/is.service.locked',
                data: {
                    plugin: manageServices.plugin,
                    serviceId: serviceId,
                    editorId: editorId
                },
                success: function (xml) {
                    var isServiceLocked = jQuery(xml).find('ef\\:result, result').text();

                    if (isServiceLocked === "false") {
                        var sdf = manageServices.adminSdf;
                        newWindow.location.href = sdf + '?_uri=//com.enginframe.service-manager/edit.service&plugin=' + encodeURIComponent(manageServices.plugin) +
                            '&serviceId=' + encodeURIComponent(serviceId) + '&serviceType=' + encodeURIComponent(serviceType) +
                            '&templateId=' + encodeURIComponent(templateId) + '&navigation=manage.services&editorId=' + encodeURIComponent(editorId);
                    }
                    else {
                        jQuery(manageServices.message).hymessage().hymessage('alert', "The Service is locked for editing by an Admin.");
                        manageServices.refresh();
                    }
                },
                error: function () {
                    manageServices.refresh();
                }
            });
        }
        else {
            var sdf = manageServices.adminSdf;
            newWindow.location.href = sdf + '?_uri=//com.enginframe.service-manager/edit.service&plugin=' + encodeURIComponent(manageServices.plugin) +
                '&serviceId=' + encodeURIComponent(serviceId) + '&serviceType=' + encodeURIComponent(serviceType) +
                '&templateId=' + encodeURIComponent(templateId) + '&navigation=manage.services&editorId=' + encodeURIComponent(editorId);
        }
    },

    goAdd: function () {
        var dialog, label, entry, button, dialogButtons, dialogId, inputId, templateId;

        dialogId = Math.floor(Math.random() * 1000) + 1;
        inputId = 'input_' + dialogId;
        templateId = 'interactive';

        dialog = jQuery('<div class="hy-simple-input-dialog" id="' + dialogId + '"/>').appendTo(jQuery('body'));
        jQuery('<div class="ui-state-highlight ui-corner-all manage-services-templates-info ui-helper-hidden" style="padding:10px 0 0 10px">' +
                '<p><span class="ui-icon ui-icon-info" style="margin:1px 5px 0 0;float:left;"></span>No templates available</p></div>').appendTo(dialog);

        var templateList = {};
        jQuery.hydrogen.invokeService({
            sdf: manageServices.adminSdf,
            uri: '//com.enginframe.service-manager/list.templates.data',
            data: {
                plugin: manageServices.plugin
            },
            success: function (xml) {
                jQuery(xml).find('ef\\:service, service').each(function () {
                    templateList[jQuery(this).attr('id')] = jQuery(this).find('ef\\:name, name').text();
                });

                if (jQuery.isEmptyObject(templateList) || Object.keys(templateList).length === 1) {
                    delete templateList.interactive;
                    jQuery('<div class="ef-template-radio"><input type="radio" name="use-template" value="interactive" checked="checked"/>Create empty Interactive Service</div>').appendTo(dialog);
                    jQuery('.manage-services-templates-info').removeClass('ui-helper-hidden');

                } else {
                    jQuery('<div class="ef-template-radio"><input type="radio" name="use-template" value="interactive" checked="checked"/>Create empty Interactive Service</div>').appendTo(dialog);
                    jQuery('<div class="ef-template-radio"><input type="radio" name="use-template" value="yes" />Create from Template:</div>').appendTo(dialog);
                    jQuery('<select class="ef-template-select greyed" id="' + inputId + '"></select>').appendTo(dialog);

                    delete templateList.interactive;
                    jQuery.each(templateList, function (key, value) {
                        jQuery('select#' + inputId).append('<option value="' + key + '">' + efEncodeHtml(value) + '</option>');
                    });

                    jQuery('.ef-template-select').click(function () {
                        jQuery('div#' + dialogId + ' input:radio[name=use-template][value=yes]').attr('checked', 'checked');
                        jQuery('.ef-template-select').removeClass('greyed').change();
                    });

                    jQuery('.ef-template-select').change(function () {
                        templateId = jQuery(this).val();
                    });

                    jQuery('div#' + dialogId + ' input:radio[name=use-template]').click(function () {
                        var useTemplate = jQuery('div#' + dialogId + ' input:radio[name=use-template]:checked').val();
                        if (jQuery('div#' + dialogId + ' input:radio[name=use-template]:checked').val() === 'yes') {
                            jQuery('.ef-template-select').removeClass('greyed').change();
                        }
                        else {
                            jQuery('.ef-template-select').addClass('greyed');
                            templateId = useTemplate;
                        }
                    });
                }
            }
        });

        dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            },
            Create: function () {
                jQuery(this).dialog("close");
                var serviceType = templateId.split('_')[0];
                manageServices.goEdit("", serviceType, templateId, false, false);
            }
        };
        dialog.dialog({
            title: "Service Creation",
            resizable: false,
            buttons: dialogButtons,
            modal: true
        });

        button = jQuery('button:contains(Create)', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
        dialog.keypress(function (e) {
            if (e.which === 13) {
                button.click();
                return false;
            }
            return true;
        });
    },

    appendUserGroups: function (inputId) {

        jQuery.hydrogen.invokeService({
            sdf: manageServices.adminSdf,
            uri: '//com.enginframe.user-group-manager/list.groups',
            dataType: 'xml',
            data: {
                namespace: manageServices.plugin
            },
            success: function (xml) {
                var userGroup, encUserGroup, userGroupList = '';
                var isAdminGroupPresent = false;
                jQuery(xml).find('ugm\\:group, group').each(function () {
                    userGroup = jQuery(this).attr('name');
                    encUserGroup = efEncodeHtml(userGroup);
                    if (userGroup !== "all-users") {
                        userGroupList += '<label><input type="checkbox" name="user-group-multiselect" value="' + encUserGroup + '" disabled="disabled"/>' + encUserGroup + '</label>';
                    }
                    if (userGroup === "admin") {
                        isAdminGroupPresent = true;
                    }
                });
                if (!isAdminGroupPresent) {
                    userGroupList += '<label><input type="checkbox" name="user-group-multiselect" value="admin" disabled="disabled"/>admin</label>';
                }
                jQuery(userGroupList).appendTo(jQuery('div#' + inputId));
            }
        });
    },

    refreshFolderList: function (inputId, selectedFolderRealName) {

        jQuery.hydrogen.invokeService({
            sdf: manageServices.adminSdf,
            uri: '//com.enginframe.service-manager/list.published.folders',
            dataType: 'xml',
            data: {
                plugin: manageServices.plugin
            },
            success: function (xml) {
                var folderName, folderList = '';
                jQuery('div#' + inputId).empty();
                jQuery(xml).find('ef\\:published-folder, published-folder').each(function () {
                    var folderRealName, folderName, element;

                    folderRealName = jQuery(this).attr('real-name');
                    folderName = jQuery(this).attr('name');
                    element = '<div class="ef-manage-services-publish-folder-item" data-value="' + folderRealName + '">' + efEncodeHtml(folderName);
                    if (jQuery(this).attr('has-services') === 'false' && folderRealName !== 'published') {
                        element += '<span class="ef-manage-services-publish-folder-delete"><i class="fa fa-trash" /></span>';
                    }
                    element += '</div>';
                    jQuery('div#' + inputId).append(element);
                    if (selectedFolderRealName === folderRealName) {
                        // select item
                        jQuery('div#' + inputId + "_selected").attr('data-value', folderRealName).text(folderName);
                    }
                });
                jQuery('.ef-manage-services-publish-folder-list-content').hide();
                jQuery('.ef-manage-services-publish-folder').click(function (event) {
                    event.stopPropagation();
                    jQuery('.ef-manage-services-publish-folder-list-content').show();
                });
                jQuery('.ef-manage-services-publish-folder-delete').click(function (event) {
                    event.stopPropagation();
                    var folderToDelete = jQuery(this).parent().attr('data-value');
                    manageServices.deleteFolder(folderToDelete, inputId);
                });
                jQuery('.ef-manage-services-publish-folder-item').click(function (event) {
                    event.stopPropagation();
                    var folderRealName, folderName;
                    folderRealName = jQuery(this).attr('data-value');
                    folderName = jQuery(this).text();
                    jQuery('div#' + inputId + "_selected").attr('data-value', folderRealName).text(folderName);
                    jQuery('.ef-manage-services-publish-folder-list-content').hide();
                });
                jQuery(document).click(function () {
                    jQuery('.ef-manage-services-publish-folder-list-content').hide();
                });
            }
        });
    },

    deleteFolder: function (folderRealName, folderInputId) {
        var msg = jQuery(manageServices.message).hymessage();
        jQuery.hydrogen.invokeService({
            sdf: manageServices.adminSdf,
            uri: '//com.enginframe.service-manager/delete.published.folder',
            data: {
                publishedFolder: folderRealName,
                plugin: manageServices.plugin
            },
            dataType: 'xml',
            success: function (xml) {
                var selectedPath = jQuery('div#' + folderInputId + "_selected").attr('data-value');
                manageServices.refreshFolderList(folderInputId, (selectedPath !== folderRealName) ? selectedPath : 'published');
            },
            error: function () {
                var selectedPath = jQuery('div#' + folderInputId + "_selected").attr('data-value');
                manageServices.refreshFolderList(folderInputId, selectedPath);
            },
            messagebox: msg
        });
    },

    exportServicesPre: function (environment) {
        var serviceIds = environment["%SELECTED_IDS%"];
        manageServices.exportServices(serviceIds);
    },

    exportServices: function (serviceIds) {
        var msg = jQuery(manageServices.message).hymessage();
        jQuery.hydrogen.invokeService({
            sdf: manageServices.adminSdf,
            uri: '//com.enginframe.service-manager/export.service',
            data: {
                serviceIds: serviceIds,
                plugin: manageServices.plugin
            },
            dataType: 'xml',
            success: function (xml) {
                var errorMsg = jQuery(xml).find('ef\\:error, error').first().find('ef\\:message, message').first().text();
                if (errorMsg) {
                    msg.hymessage('alert', errorMsg);
                }
                location.href = jQuery(xml).find('ef\\:redirect, redirect').first().text();
            },
            messagebox: msg
        });
    },

    importServices: function () {
        var dialog, label, form, isUploading, self, msg;

        msg = jQuery(manageServices.message).hymessage();
        isUploading = false;
        dialog = jQuery('<div class="hy-simple-input-dialog"/>').appendTo(jQuery('body'));
        label = jQuery('<label for="new-value">Services archive to upload:</span>').appendTo(dialog);
        form = jQuery('<form id="upload-form" action="' + manageServices.adminSdf +
                      '?_uri=//com.enginframe.service-manager/import.service" method="post">' +
                      '    <input type="hidden" name="plugin" value="' + manageServices.plugin + '"/>' +
                      '    <input type="file" id="archive" name="archive" style="width:100%"/>' +
                      '</form>').appendTo(dialog);

        dialog.dialog({
            title: "Upload Services",
            resizable: false,
            buttons: {
                Cancel: function () {
                    jQuery(this).dialog("close");
                },
                Upload: function () {
                    form.submit();
                }
            },
            beforeclose: function (event, ui) {
                if (isUploading) {
                    return false;
                }
            },
            modal: true
        });

        jQuery('button:contains("Upload")', dialog.parent('div.ui-dialog')).addClass('ui-priority-primary');

        self = this;

        // attach handler to form's submit event
        form.submit(function () {
            var newValue;

            if (isUploading) {
                return false;
            }

            newValue = jQuery('#archive', jQuery(this)).val();
            if (newValue.length <= 0) {
                return false;
            }

            isUploading  = true;

            jQuery('<img class="hy-upload-indicator" src="/' + jQuery.enginframe.rootContext + '/hydrogen/images/indicator.gif"/>').appendTo(jQuery('.ui-dialog-buttonpane', dialog.parent('div.ui-dialog')));

            dialog.dialog('disable');

            // submit the form
            jQuery(this).ajaxSubmit({
                dataType: 'xml',
                success: function (responseText, statusText) {
                    msg.css('white-space', 'pre-wrap');
                    msg.hymessage('info', jQuery(responseText).find('ef\\:message, message').text(), 5000);
                    manageServices.refresh();
                    isUploading = false;
                    dialog.dialog('close');
                },
                error: function (xhr, statusText, errorThrown) {
                    msg.css('white-space', 'pre-wrap');
                    msg.hymessage('alert', jQuery(xhr.responseText).find('ef\\:message, message').text(), 5000);
                    manageServices.refresh();
                    isUploading = false; // not needed but for formal correctness
                    dialog.dialog('close');
                }
            });
            // return false to prevent normal browser submit and page navigation
            return false;
        });
    },

    goPublish: function (serviceIds, serviceName) {
        var dialog, label, entry, button, dialogButtons, dialogId, inputId, availableAcl, folderInputId;

        dialogId = Math.floor(Math.random() * 1000) + 1;
        inputId = 'input_' + dialogId;

        if (serviceName) {
            label = "Make the '" + efEncodeHtml(serviceName) + "' Service available to:";
        }
        else {
            label = "Make the selected Services available to:";
        }

        dialog = jQuery('<div class="ef-manage-services-publish-dialog" id="' + dialogId + '"/>').appendTo(jQuery('body'));
        jQuery('<div class="ef-manage-services-publish-message" style="display:none;" />').appendTo(dialog);
        jQuery('<label for="new-value" style="display:block;padding-bottom:5px;">' + label + '</label>').appendTo(dialog);
        jQuery('<div class="input-radio"><input type="radio" name="users" value="all" checked="checked"/>All Users</div>').appendTo(dialog);
        jQuery('<div class="input-radio"><input type="radio" name="users" value="allow"/>Selected Groups</div>').appendTo(dialog);
        jQuery('<div class="input-radio"><input type="radio" name="users" value="deny"/>All Users excluding selected Groups</div>').appendTo(dialog);

        jQuery('<div class="ef-ugm-multiselect greyed" id="' + inputId + '"></div>').appendTo(dialog);
        manageServices.appendUserGroups(inputId);

        jQuery('div#' + dialogId + ' input:radio[name=users]').click(function () {
            if (jQuery('div#' + dialogId + ' input:radio[name=users]:checked').val() === "all") {
                jQuery('.ef-ugm-multiselect input:checkbox[name=user-group-multiselect]').addClass('greyed').attr('disabled', 'disabled');
                jQuery('div#' + inputId).addClass('greyed');
            }
            else {
                jQuery('.ef-ugm-multiselect input:checkbox[name=user-group-multiselect]').removeClass('greyed').removeAttr('disabled');
                jQuery('div#' + inputId).removeClass('greyed');
            }
        });

        folderInputId = 'folder_' + inputId;
        jQuery('<div class="ef-manage-services-publish-text">in folder:</div>').appendTo(dialog);
        jQuery('<div class="ef-manage-services-publish-folder">' +
                  '<div class="ef-manage-services-publish-folder-selected" id="' + folderInputId + '_selected"/>' +
                  '<i class="fa fa-caret-down" />' +
              '</div>').appendTo(dialog);
        jQuery('<div class="ef-manage-services-publish-folder-list"><div class="ef-manage-services-publish-folder-list-content" id="' + folderInputId + '"/></div>').appendTo(dialog);
        manageServices.refreshFolderList(folderInputId, 'published');

        jQuery('<span class="ef-manage-services-publish-folder-new"><i class="fa fa-plus"/></span>').button().appendTo(dialog);
        jQuery('.ef-manage-services-publish-folder-new').click(function () {
            var msg = jQuery(manageServices.message).hymessage();
            manageServices.simpleInputDialog("New Folder", "Folder name", "Add", "", true, function (newFolderName) {
                newFolderName = newFolderName.replace(/^\s+|\s+$/gm,'');
                if (!/^[_a-zA-Z0-9][_a-zA-Z0-9.\- ]*$/.test(newFolderName)) {
                    jQuery('.ef-manage-services-publish-message').hymessage().hymessage('alert', "Invalid directory name: the format must be [_a-zA-Z0-9][_a-zA-Z0-9.- ]");
                    return;
                }
                else {
                    jQuery('.ef-manage-services-publish-message').hymessage().hymessage('destroy');
                }
                jQuery.hydrogen.invokeService({
                    sdf: manageServices.adminSdf,
                    uri: '//com.enginframe.service-manager/create.published.folder',
                    data: {
                        publishedFolder: newFolderName,
                        plugin: manageServices.plugin
                    },
                    success: function (xml) {
                        var newFolderRealName = jQuery(xml).find('ef\\:result, result').first().text();
                        manageServices.refreshFolderList(folderInputId, newFolderRealName);
                    },
                    messagebox: msg
                });
            });
        });

        dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons.Publish = function () {
            var userGroupList, msg, selectedValue, access, targetFolderName;

            selectedValue = jQuery('div#' + dialogId + ' input:radio[name=users]:checked').val();
            if (selectedValue === "all") {
                userGroupList = "all-users";
                access = "allow";
            }
            else {
                access = selectedValue;
                userGroupList = '';
                jQuery('div#' + dialogId + ' input:checkbox[name=user-group-multiselect]:checked').each(function (index) {
                    if (index !== 0) {
                        userGroupList += ',';
                    }
                    userGroupList += jQuery(this).val() + ':' + access;
                });
            }

            if (userGroupList.length <= 0) {
                return false;
            }
            jQuery(this).dialog("close");

            targetFolderName = jQuery('div#' + folderInputId + "_selected").attr('data-value');

            msg = jQuery(manageServices.message).hymessage();
            jQuery.hydrogen.invokeService({
                sdf: manageServices.adminSdf,
                uri: '//com.enginframe.service-manager/publish.service',
                data: {
                    serviceIds: serviceIds,
                    userGroupList: userGroupList,
                    plugin: manageServices.plugin,
                    targetFolderName: targetFolderName
                },
                success: function (xml) {
                    manageServices.refresh();
                },
                error: function () {
                    manageServices.refresh();
                },
                messagebox: msg
            });

        };

        dialog.dialog({
            title: "Publish",
            resizable: false,
            buttons: dialogButtons,
            modal: true
        });

        button = jQuery('button:contains(Publish)', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
        dialog.keypress(function (e) {
            if (e.which === 13) {
                button.click();
                return false;
            }
            return true;
        });
    },

    goPublishPre: function (environment) {
        var serviceIds = environment["%SELECTED_IDS%"];
        manageServices.goPublish(serviceIds);
    },

    simpleInputDialog: function (dialogTitle, inputLabel, buttonLabel, oldValue, check, actionfunc) {
        var dialog, entry, button, dialogButtons;

        if (/^[a-zA-Z0-9- ]*$/.test(oldValue) && jQuery(oldValue).is("div")) {
            oldValue = jQuery(oldValue).text();
        }
        dialog = jQuery('<div class="hy-simple-input-dialog"/>').appendTo(jQuery('body'));
        jQuery('<label for="new-value" style="display:block">' + efEncodeHtml(inputLabel) + ':</label>').appendTo(dialog);
        entry = jQuery('<input type="text" name="value" id="new-value" style="width:90%"/>').appendTo(dialog);
        entry.val(oldValue);

        dialogButtons = {
            Cancel: function () {
                jQuery(this).dialog("close");
            }
        };
        dialogButtons[buttonLabel] = function () {
            var newValue = entry.val();
            if (check === true) {
                if (newValue.length <= 0) {
                    return false;
                }
            }
            jQuery(this).dialog("close");
            actionfunc(newValue);
        };

        dialog.dialog({
            title: dialogTitle,
            resizable: false,
            buttons: dialogButtons,
            modal: true
        });

        button = jQuery('button:contains(' + buttonLabel + ')', dialog.parent('div.ui-dialog'));
        button.addClass('ui-priority-primary');
        entry.keypress(function (e) {
            if (e.which === 13) {
                button.click();
                return false;
            }
            return true;
        });
    }
};
// ex:ts=4:et:

