<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ef="http://www.enginframe.com/2000/EnginFrame"
                xmlns:efx="xalan://com.enginframe.xslt.xalan.Extensions"
                extension-element-prefixes="efx"
                exclude-result-prefixes="ef efx">

<!--
 * Copyright 2023-2025 by NI SP Software GmbH, All rights reserved.
 * Copyright 1999-2023 by Nice, srl., All rights reserved.
 *
 * This software includes confidential and proprietary information
 * of NI SP Software GmbH ("Confidential Information").
 * You shall not disclose such Confidential Information
 * and shall use it only in accordance with the terms of
 * the license agreement you entered into with NI SP Software.-->

  <xsl:template name="vdi_login">
    <html>
      <efx:acl>
        <ef:choose-acl>
        <!--
          <ef:when-acl select="vdi">
        -->
          <ef:when-acl select="allow-to[vdi:all-users]">
            <head>
              <xsl:call-template name="nj_head_rendering"/>
            </head>
            <body>
              <div id="nj-container">
                <xsl:call-template name="nj_banner_rendering"/>
                <div id="nj-wrapper">
                  <xsl:call-template name="nj_navigation_rendering"/>
                  <xsl:call-template name="nj_content_rendering"/>
                </div>
                <xsl:call-template name="nj_footer_rendering"/>
              </div>
            </body>
          </ef:when-acl>
          <ef:when-acl select="logged-users">
            <head>
              <xsl:call-template name="nj_head_rendering"/>
            </head>
            <body>
              <div id="nj-container">
                <xsl:call-template name="nj_banner_rendering"/>
                <div id="login-container">
                  <div class="ui-widget ui-state-error ui-corner-all" id="ef_login_error">
                    <strong>User Access Error</strong>
                    <p>Access Failure: User not authorized. Contact EF Portal Administrator.</p>
                  </div>
                </div>
                <xsl:call-template name="nj_footer_rendering"/>
              </div>
            </body>
          </ef:when-acl>
          <ef:otherwise>
            <!-- If not logged in, show the login form -->
            <head>
              <xsl:call-template name="nj_head_rendering"/>
            </head>
            <body class="vdi-login">
              <div id="nj-container">
                <div id="login-container">
                  <div id="nj-banner">
                    <xsl:call-template name="ef.logo" />
                  </div>
                  <h2 id="nj-login-title"><xsl:value-of select='$nj.ef.version'/></h2>
                  <!-- let system xsl render the login form -->
                  <xsl:call-template name="content_rendering"/>
                  <xsl:call-template name="nj_footer_login_rendering"/>
                </div>
              </div>
            </body>
          </ef:otherwise>
        </ef:choose-acl>
      </efx:acl>
    </html>
  </xsl:template>

</xsl:stylesheet>
